unit uSetDetail;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComObj;

type
  TSetDetail = class(TForm)
    DaySelect: TShape;
    Label1: TLabel;
    ClassBox: TShape;
    DNbrBox: TShape;
    CNbrBox: TShape;
    DayBox1: TShape;
    ClassAccessSelect: TShape;
    ClassAccessBox: TShape;
    DrawTimer: TTimer;
    DayBox2: TShape;
    TNbrBox: TShape;
    TeacherBox: TShape;
    btnExcel: TButton;
    btnClose: TButton;
    btnSubject: TButton;
    procedure DrawDayLabel;
    procedure DrawDayPanel;
    procedure DrawClassLabel;
    procedure DrawTeacherLabel;
    procedure DrawClassPanel;
    procedure DrawClassAccessPanel;
    procedure DrawClassAccessDetail;
    procedure DrawTeacherAccessPanel;
    procedure DrawTeacherAccessDetail;
    procedure DrawTeacherPanel;
    procedure ReadDetail;
    procedure WriteDetail;
    procedure DrawDetail;
    procedure FormActivate(Sender: TObject);
    procedure txtMouseEnter(Sender: TObject);
    procedure txtMouseLeave(Sender: TObject);
    procedure optMouseEnter(Sender: TObject);
    procedure optMouseLeave(Sender: TObject);
    procedure DayClick(Sender: TObject);
    procedure PreDayClick(Sender: TObject);
    procedure ClassClick(Sender: TObject);
    procedure PreClassClick(Sender: TObject);
    procedure PreClassClick2(Sender: TObject);
    procedure PreClassClickZ(Sender: TObject);
    procedure TeacherClick(Sender: TObject);
    procedure PreTeacherClick(Sender: TObject);
    procedure PreTeacherClickZ(Sender: TObject);
    procedure DNbrClick(Sender: TObject);
    procedure ClassAccessMouseEnter(Sender: TObject);
    procedure ClassAccessMouseLeave(Sender: TObject);
    procedure ClassAccessClick(Sender: TObject);
    procedure GetUsedTeacher(DayNbr, LessonNbr:integer);
    procedure GetUsedRoom(DayNbr, LessonNbr:integer);
    procedure ClassAccessDefine(Sender: TObject);
    procedure DrawTimerTimer(Sender: TObject);
    procedure DeleteInfo(Sender: TObject);
    procedure btnExcelClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnSubjectClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SetDetail: TSetDetail;

implementation

uses udm;

{$R *.dfm}

procedure TSetDetail.FormActivate(Sender: TObject);
begin
  dm.tDetail.Filter := 'SchYear = '+IntToStr(vSchYear);
  dm.tDetail.Filtered := true;
  dm.tTeacher.Filter := 'LastYear >= '+IntToStr(vSchYear);
  dm.tTeacher.Filtered := true;
  dm.tTutorArrange.Filter := 'SchYear = '+IntToStr(vSchYear);
  dm.tTutorArrange.Filtered := true;
  dm.tTeacher.Open;
  dm.qSubject.Open;
  dm.tClass.Open;
  dm.tTutorArrange.Open;
  Top    := 26;
  Left   := 0;
  Width  := Screen.Width;
  Height := 768-26;
  Color  := clCream;
  cDay   := 0;
  cClass := '1A';
  DrawDayPanel;
  DrawClassPanel;
  DrawClassAccessPanel;
  DrawTeacherPanel;
  DrawTeacherAccessPanel;
  DrawClassLabel;
  DrawDayLabel;
  ReadDetail;
  DrawTeacherLabel;
  DayLabel[1].OnClick(DayLabel[1]);
  ClassLabel[1].OnClick(ClassLabel[1]);
  DNbrLabel[1].OnClick(DNbrLabel[1]);
  TeacherLabel[1].OnClick(TeacherLabel[1]);
end;

procedure TSetDetail.txtMouseEnter(Sender: TObject);
begin
  TLabel(Sender).Transparent := false;
  TLabel(Sender).Font.Color  := clBlue;
  TLabel(Sender).Color       := clYellow;
end;

procedure TSetDetail.txtMouseLeave(Sender: TObject);
begin
  TLabel(Sender).Transparent := true;
  TLabel(Sender).Font.Color  := clNavy;
  TLabel(Sender).Color       := clCream;
end;

procedure TSetDetail.optMouseEnter(Sender: TObject);
begin
  TLabel(Sender).Transparent := false;
  TLabel(Sender).Font.Color  := clBlue;
  TLabel(Sender).Color       := $00A2FFFF;
end;

procedure TSetDetail.optMouseLeave(Sender: TObject);
begin
  TLabel(Sender).Transparent := true;
  TLabel(Sender).Font.Color  := clNavy;
  TLabel(Sender).Color       := clCream;
end;

procedure TSetDetail.DrawDayLabel;
var i:integer;
begin
  for i := Low(Days) to High(Days) do begin
    DayLabel[i] := TLabel.Create(Self);
    with DayLabel[i] do begin
      Autosize     := false;
      Left         := defWidth * 3 * (i-1) + 2;
      Top          := 1;
      Width        := defWidth * 3 - 2;
      Height       := defHeight div 2 - 2;
      Alignment    := taCenter;
      Layout       := tlCenter;
      Font.Name    := 'sө';
      Font.Size    := 12;
      Font.Color   := clNavy;
      Caption      := Days[i];
      Transparent  := true;
      Tag          := i;
      Parent       := Self;
      OnMouseEnter := txtMouseEnter;
      OnMouseLeave := txtMouseLeave;
      OnClick      := DayClick;
    end;
  end;
end;

procedure TSetDetail.DayClick(Sender: TObject);
begin
  DaySelect.Left    := TLabel(Sender).Left - 1;
  DaySelect.Top     := TLabel(Sender).Top  - 1;
  DaySelect.Width   := TLabel(Sender).Width + 2;
  DaySelect.Height  := TLabel(Sender).Height + 2;
  DaySelect.Visible := true;
  DaySelect.SendToBack;
  cDay := TLabel(Sender).Tag;
  DayPanel.Caption := EDays[cDay];
  DayBox1.Top       := 0;
  DayBox1.Left      := defWidth * cDay;
  DayBox1.Width     := defWidth + 1;
  DayBox1.Height    := ClassPanel.Height;
  DayBox1.Parent    := ClassPanel;
  DayBox1.Visible   := true;
  DayBox2.Top       := 0;
  DayBox2.Left      := defWidth * cDay;
  DayBox2.Width     := defWidth + 1;
  DayBox2.Height    := ClassPanel.Height;
  DayBox2.Parent    := TeacherPanel;
  DayBox2.Visible   := true;
  if DrawTimer.Enabled = false then DrawTimer.Enabled := true;
end;

procedure TSetDetail.PreDayClick(Sender: TObject);
begin
  DayClick(DayLabel[TLabel(Sender).Tag]);
end;

procedure TSetDetail.DrawDayPanel;
var i,j:integer;
begin
//  for i := Low(Days) to High(Days) do begin
  for i := 1 to 1 do begin
    DayPanel := TPanel.Create(Self);
    with DayPanel do begin
      Autosize     := false;
      Left         := 2;
      Top          := defHeight div 2;
      Width        := defWidth * (maxColumn+1) + 1;
      Height       := defHeight * maxRow + defClassHeight + 1;
      Alignment    := taCenter;
      Font.Name    := 'Arial';
      Font.Size    := 72;
      Font.Color   := $00E1C4FF;
      DockSite     := true;
      UseDockManager := false;
      Color        := clCream;
      BevelOuter   := bvNone;
      BevelInner   := bvNone;
      Caption      := EDays[i];
      Tag          := i;
      Parent       := Self;
      for j := 0 to maxColumn+1 do begin
        with TShape.Create(Self) do begin { draw vertical lines }
          if j = 0 then Left := 0
                   else Left := defWidth * j;
          Top         := 0;
          Width       := 1;
          Height      := DayPanel.Height;
          Pen.Color   := clAqua;
          Brush.Style := bsClear;
          ShowHint    := true;
          Hint        := 'Left = '+IntToStr(Left);
          Parent      := DayPanel;
        end;
      end;
      for j := 0 to maxRow+1 do begin
        with TShape.Create(Self) do begin { draw horizontal lines }
          case j of
            0 : Top := 0;
            1 : Top := defClassHeight;
            else Top := defHeight * (j-1) + defClassHeight;
          end;
          Left         := 0;
          Height       := 1;
          Width      := DayPanel.Width;
          Pen.Color   := clAqua;
          ShowHint    := true;
          Hint        := 'Top = '+IntToStr(Top);
          Brush.Style := bsClear;
          Parent      := DayPanel;
        end;
        if j > 0 then begin
          DNbrLabel[j] := TLabel.Create(Self);
          with DNbrLabel[j] do begin { draw number 1 to 9 }
            case j of
              1 : Top := defClassHeight+1;
              else Top := defHeight * (j-1) + defClassHeight + 1;
            end;
            Left         := 0;
            Autosize     := false;
            Alignment    := taCenter;
            Layout       := tlCenter;
            Height       := defHeight - 1;
            Width        := defWidth - 1;
            Font.Color   := clNavy;
            Font.Name    := 'Arial';
            Font.Size    := 12;
            Transparent  := true;
            Tag          := j;
            OnMouseEnter := txtMouseEnter;
            OnMouseLeave := txtMouseLeave;
            Parent       := DayPanel;
            Caption      := IntToStr(j);
            OnClick      := DNbrClick;
          end;
        end;
      end;
    end;
  end;
end;

procedure TSetDetail.DrawClassLabel;
var j:integer;
begin
  mClass := dm.tClass.RecordCount;
  dm.tClass.first;
  for j := 1 to mClass do begin
    ClassLabel[j] := TLabel.Create(Self); { creat class label }
    with ClassLabel[j] do begin
      Autosize := false;
      if j = 0 then Left := 0
               else Left := defWidth * j + 1;
      Top       := 1;
      Width     := defWidth-1;
      Height    := defClassHeight - 1;
      Caption   := dm.tClass.FieldByName('ID').AsString;
      dm.tClass.Next;
      Parent    := DayPanel;
      Alignment := taCenter;
      Layout    := tlCenter;
      Font.Color := clNavy;
      Font.Size  := 8;
      Transparent  := true;
      Font.Name  := 'MS Sans Serif';
      Tag        := j;
      BringToFront;
      OnMouseEnter := txtMouseEnter;
      OnMouseLeave := txtMouseLeave;
      OnClick      := ClassClick;
    end;
  end;
end;

procedure TSetDetail.DrawTeacherLabel;
var m, j, k :integer;
begin
  m := Length(TeacherList);// div 2;
  for j := 1 to m do begin
    TeacherLabel[j] := TLabel.Create(Self); { creat class label }
    with TeacherLabel[j] do begin
      Autosize := false;
      if j mod 5 = 0
      then Top := ClassAccessPanel.Height + ClassAccessPanel.Top + defClassHeight * (j div 5)
      else Top := ClassAccessPanel.Height + ClassAccessPanel.Top + defClassHeight * ((j div 5)+1);
      k := j mod 5;
      if k = 0 then k := 5;
      Left      := ClassAccessPanel.Left + (k-1) * (defWidth) + (defWidth ) - 4 ;
      Width     := defWidth-1;
      Height    := defClassHeight - 1;
      Caption   := Copy(TeacherList, j, 1);
      Parent    := Self;
      Alignment := taCenter;
      Layout    := tlCenter;
      Font.Color := clNavy;
      Font.Size  := 12;
      Font.Name  := 'sө';
      Transparent  := true;
      Tag        := j;
      BringToFront;
      OnMouseEnter := txtMouseEnter;
      OnMouseLeave := txtMouseLeave;
      OnClick      := TeacherClick;
    end;
  end;
end;

procedure TSetDetail.ClassClick(Sender: TObject);
begin
  cClass := TLabel(Sender).Caption;
  dm.tClass.Locate('ID', cClass, []);
  ClassBox.Left    := TLabel(Sender).Left - 1;
  ClassBox.Top     := 0;
  ClassBox.Width   := defWidth + 1;
  ClassBox.Height  := DayPanel.Height;
  ClassBox.Visible := true;
  ClassBox.BringToFront;
  ClassBox.Parent := DayPanel;
  ClassPanel.Caption := cClass;
  if DrawTimer.Enabled = false then DrawTimer.Enabled := true;
end;

procedure TSetDetail.PreClassClick(Sender: TObject);
var i:integer;
begin
  for i := 1 to mClass do begin
    if TLabel(Sender).Caption = ClassLabel[i].Caption then begin
      ClassClick(ClassLabel[i]);
      DayClick(DayLabel[Details[StrToInt(TLabel(Sender).Hint)].DayCode]);
      DNbrClick(DNbrLabel[Details[StrToInt(TLabel(Sender).Hint)].LessonCode]);
    end;
  end;
end;

procedure TSetDetail.PreClassClick2(Sender: TObject);
var i:integer;
begin
  for i := 1 to mClass do begin
    if TLabel(Sender).Caption = ClassLabel[i].Caption then begin
      ClassClick(ClassLabel[i]);
      DayClick(DayLabel[cDay]);
      DNbrClick(DNbrLabel[cLesson]);
    end;
  end;
end;

procedure TSetDetail.PreClassClickZ(Sender: TObject);
var n:integer;
begin
  n := StrToInt(TLabel(Sender).Hint);
  ClassClick(ClassLabel[Details[n].ClassID]);
  DayClick(DayLabel[Details[n].DayCode]);
  DNbrClick(DNbrLabel[Details[n].LessonCode]);
end;

procedure TSetDetail.TeacherClick(Sender: TObject);
begin
  cTeacher := TLabel(Sender).Caption;
  TeacherBox.Left    := TLabel(Sender).Left - 1;
  TeacherBox.Top     := TLabel(Sender).Top - 1;
  TeacherBox.Width   := TLabel(Sender).Width  + 2;
  TeacherBox.Height  := TLabel(Sender).Height + 2;
  TeacherBox.Visible := true;
  TeacherBox.BringToFront;
  TeacherBox.Parent := Self;
  TeacherPanel.Caption := TLabel(Sender).Caption;
  TeacherAccessPanel.Caption := TLabel(Sender).Caption;
  if DrawTimer.Enabled = false then DrawTimer.Enabled := true;
end;

procedure TSetDetail.PreTeacherClick(Sender: TObject);
var i:integer;
begin
  for i := 1 to mTeacher do begin
    if TLabel(Sender).Caption = TeacherLabel[i].Caption then begin
      TeacherClick(TeacherLabel[i]);
      DayClick(DayLabel[Details[StrToInt(TLabel(Sender).Hint)].DayCode]);
      ClassClick(ClassLabel[Details[StrToInt(TLabel(Sender).Hint)].ClassID]);
      DNbrClick(DNbrLabel[Details[StrToInt(TLabel(Sender).Hint)].LessonCode]);
    end;
  end;
end;

procedure TSetDetail.PreTeacherClickZ(Sender: TObject);
var i:integer;
begin
  for i := 1 to mTeacher do begin
    if TLabel(Sender).Caption = TeacherLabel[i].Caption then begin
      TeacherClick(TeacherLabel[i]);
      DayClick(DayLabel[Details[StrToInt(TLabel(Sender).Hint)].DayCode]);
      ClassClick(ClassLabel[Details[StrToInt(TLabel(Sender).Hint)].ClassID]);
      DNbrClick(DNbrLabel[Details[StrToInt(TLabel(Sender).Hint)].LessonCode]);
    end;
  end;
end;

procedure TSetDetail.DNbrClick(Sender: TObject);
var i:integer;
begin
  DNbrBox.Left    := 0;
  DNbrBox.Top     := TLabel(Sender).Top - 1;
  DNbrBox.Width   := DayPanel.Width;
  DNbrBox.Height  := defHeight+1;
  DNbrBox.Visible := true;
  DNbrBox.BringToFront;
  DNbrBox.Parent := DayPanel;
  cLesson := TLabel(Sender).Tag;
  CNbrBox.Left    := 0;
  CNbrBox.Top     := TLabel(Sender).Top - 1;
  CNbrBox.Width   := ClassPanel.Width;
  CNbrBox.Height  := defHeight+1;
  CNbrBox.Visible := true;
  CNbrBox.BringToFront;
  CNbrBox.Parent := ClassPanel;
  TNbrBox.Left    := 0;
  TNbrBox.Top     := TLabel(Sender).Top - 1;
  TNbrBox.Width   := ClassPanel.Width;
  TNbrBox.Height  := defHeight+1;
  TNbrBox.Visible := true;
  TNbrBox.BringToFront;
  TNbrBox.Parent := TeacherPanel;
  for i := 0 to ComponentCount-1 do
    if Components[i].Tag = 114499 then TLabel(Components[i]).BringToFront;
end;

procedure TSetDetail.DrawClassPanel;
var i,j:integer;
begin
  dm.tClass.First;
//  for i := 1 to mClass do begin
  for i := 1 to 1 do begin
    ClassPanel := TPanel.Create(Self);
    { draw panel ==============================================================}
    with ClassPanel do begin
      Autosize     := false;
      Left         := DayPanel.Width+16;
      Top          := defHeight div 2;
      Width        := defWidth * (maxDay+1) +1;
      Height       := defHeight * maxRow + defClassHeight + 1;
      Alignment    := taCenter;
      Font.Name    := 'Arial';
      Font.Size    := 50;
      Font.Color   := $00E1C4FF;
      Color        := $00E8FFFF-40;
      BevelOuter   := bvNone;
      BevelInner   := bvNone;
      Caption      := dm.tClass.FieldByName('ID').AsString;
      dm.tClass.next;
      Tag          := i;
      Parent       := Self;
      for j := 0 to maxDay+1 do begin
        { draw vertical lines -------------------------------------------------}
        if not (j in [maxDay+2, maxDay+3]) then
        with TShape.Create(Self) do begin
          if j = 0 then Left := 0
                   else Left := defWidth * j;
          Top         := 0;
          Width       := 1;
          Height      := ClassPanel.Height;
          Pen.Color   := clAqua;
          Brush.Style := bsClear;
          ShowHint    := true;
          Hint        := 'Left = '+IntToStr(Left);
          Parent      := ClassPanel;
        end;
        { draw week day number @ to  ---------------------------------------}
        if j in [1..5] then
        with TLabel.Create(Self) do begin
          Top          := 1;
          Left         := defWidth * (j);
          Autosize     := false;
          Alignment    := taCenter;
          Layout       := tlCenter;
          Height       := defClassHeight - 1;
          Width        := defWidth - 1;
          Font.Color   := clNavy;
          Font.Name    := 'Arial';
          Font.Size    := 12;
          Transparent  := true;
          Tag          := j;
          Parent       := ClassPanel;
          OnMouseEnter := txtMouseEnter;
          OnMouseLeave := txtMouseLeave;
          Caption      := Copy(Days[j],5,2);
          OnClick      := PreDayClick;
        end;
      end;
      for j := 0 to maxRow+1 do begin
        { draw horizontal lines -----------------------------------------------}
        with TShape.Create(Self) do begin
          case j of
            0 : Top := 0;
            1 : Top := defClassHeight;
            else Top := defHeight * (j-1) + defClassHeight;
          end;
          Left         := 0;
          Height       := 1;
          if j in [0, maxRow+1] then Width := ClassPanel.Width
                                else Width := defWidth * 6;
          Pen.Color   := clAqua;
          ShowHint    := true;
          Hint        := 'Top = '+IntToStr(Top);
          Brush.Style := bsClear;
          Parent      := ClassPanel;
        end;
        { draw lesson number 1 to 9 -------------------------------------------}
        if j in [1..maxRow] then begin
          CNbrLabel[j] := TLabel.Create(Self);
          with CNbrLabel[j] do begin
            case j of
              1 : Top := defClassHeight+1;
              else Top := defHeight * (j-1) + defClassHeight + 1;
            end;
            Left         := 0;
            Autosize     := false;
            Alignment    := taCenter;
            Layout       := tlCenter;
            Height       := defHeight - 1;
            Width        := defWidth - 1;
            Font.Color   := clNavy;
            Font.Name    := 'Arial';
            Font.Size    := 12;
            Transparent  := true;
            Tag          := j;
            Parent       := ClassPanel;
            OnMouseEnter := txtMouseEnter;
            OnMouseLeave := txtMouseLeave;
            Caption      := IntToStr(j);
            OnClick      := DNbrClick;
          end;
        end;
      end;
    end;
  end;
end;

procedure TSetDetail.DrawClassAccessPanel;
begin
  if dm.tClass.Locate('ID', cCLass, []) then begin
    ClassAccessPanel := TPanel.Create(Self);
    { draw panel ==============================================================}
    with ClassAccessPanel do begin
      Autosize     := false;
      Left         := ClassPanel.Left + ClassPanel.Width - 1;
      Top          := defHeight div 2;
      Width        := defWidth * (maxDay+1) + 1;
      Height       := defHeight * 3 + 1;
      Alignment    := taCenter;
      Font.Name    := 'Arial';
      Font.Size    := 30;
      Font.Color   := $00E1C4FF;
      Color        := ClassPanel.Color;
      BevelOuter   := bvNone;
      BevelInner   := bvNone;
      Caption      := cClass;
      Parent       := Self;
      with TShape.Create(Self) do begin
        Align     := alClient;
        Pen.Color := clAqua;
        Brush.Style := bsClear;
        Parent    := ClassAccessPanel;
      end;
    end;
    ClassAccessPanel.SendToBack;
  end;
end;

procedure TSetDetail.DrawTeacherAccessPanel;
begin
    TeacherAccessPanel := TPanel.Create(Self);
    { draw panel ==============================================================}
    with TeacherAccessPanel do begin
      Autosize     := false;
      Left         := ClassPanel.Left + ClassPanel.Width + 14;
      Top          := ClassPanel.Top + ClassPanel.Height - defHeight * 3 - 1;
      Width        := defWidth * (maxDay+1) + 1;
      Height       := defHeight * 3 + 1;
      Alignment    := taCenter;
      Font.Name    := 'з';
      Font.Size    := 72;
      Font.Color   := $00E1C4FF;
      Color        := TeacherPanel.Color;
      BevelOuter   := bvNone;
      BevelInner   := bvNone;
      Caption      := cClass;
      Parent       := Self;
      with TShape.Create(Self) do begin
        Align     := alClient;
        Pen.Color := clAqua;
        Brush.Style := bsClear;
        Parent    := TeacherAccessPanel;
      end;
    end;
    TeacherAccessPanel.SendToBack;
end;

procedure TSetDetail.DrawClassAccessDetail;
var j,n, m, u, jj:integer;
    f:boolean;
begin
  ClassAccessPanel.Caption := cClass;

  dm.tTutorArrange.first;
  j := 1;
  while not dm.tTutorArrange.Eof do begin
    n := pos(dm.tTutorArrange.FieldByName('TchrCode').AsString, UsedTeacher); ///CCC
    if dm.tTutorArrange.FieldByName('RoomID').AsString = ''
    then u := 0
    else if UsedRoom = '' then u := 0
    else u:= pos('*'+dm.tTutorArrange.FieldByName('RoomID').AsString+' ', UsedRoom);

{            if dm.qSubject.Locate('Code', dm.tTutorArrange.FieldByName('Subj').AsString, [])
            then jj := dm.qSubject.FieldByName('id').AsInteger
            else jj := 0;}

//    m := dm.tTutorArrange.FieldByName('Nbr').AsInteger - SubjectReduction[j];
    m := 1;

    f := (n = 0) and (m > 0) and (u = 0);
          AccessNbrLabel[j] := TLabel.Create(Self);
          with AccessNbrLabel[j] do begin
            if j > 6 then Left := defWidth*3 + 35
                     else Left := 35;
            if j > 6 then Top  := (j-7)*defHeight div 2 + 1
                     else Top  := (j-1)*defHeight div 2 + 1;
            if dm.qSubject.Locate('Code', dm.tTutorArrange.FieldByName('Subj').AsString, [])
            then jj := dm.qSubject.FieldByName('id').AsInteger
            else jj := 0;
            Caption := IntToStr(dm.tTutorArrange.FieldByName('Nbr').AsInteger
                     - SubjectReduction[jj]);
            if '0' = IntToStr(dm.tTutorArrange.FieldByName('Nbr').AsInteger
                     - SubjectReduction[jj]) then f := false;
            if f then Font.Color := clNavy
                 else Font.Color := clAqua;
            Transparent := true;
            Hint       := IntToStr(j);
            Font.Size  := 8;
            Font.Name  := 'Times New Roman';
            Layout     := tlTop;
            Transparent  := true;
            Autosize   := false;
            Height     := defHeight div 2 - 1;
            Tag          := 114499;
            Parent     := ClassAccessPanel;
            if f then begin
              OnMouseEnter := ClassAccessMouseEnter;
              OnClick      := ClassAccessDefine;
            end;
            OnMouseLeave := ClassAccessMouseLeave;
          end;
    AccessSubjectLabel[j] := TLabel.Create(Self);
    with AccessSubjectLabel[j] do begin
       if j > 6 then Left := defWidth*3 + 1
                     else Left    := 1;
            if j > 6 then Top  := (j-7)*defHeight div 2 + 1
                     else Top  := (j-1)*defHeight div 2 + 1;
            Caption := dm.tTutorArrange.FieldByName('Subj').AsString;
            if f then Font.Color := clNavy
                 else Font.Color := clAqua;
            Font.Size  := 12;
            Font.Name  := 'sө';
            Layout     := tlCenter;
            Transparent := true;
            Autosize   := false;
            Hint       := IntToStr(j);
            Height     := defHeight div 2 - 1;
            Parent     := ClassAccessPanel;
            Tag          := 114499;
            if f then begin
              OnMouseEnter := ClassAccessMouseEnter;
              OnClick      := ClassAccessDefine;
            end;
            OnMouseLeave := ClassAccessMouseLeave;
          end;
          AccessTeacherLabel[j] := TLabel.Create(Self);
          with AccessTeacherLabel[j] do begin
            if j > 6 then Left := defWidth*3 + 18
                     else Left := 18;
            if j > 6 then Top  := (j-7)*defHeight div 2 + 1
                     else Top  := (j-1)*defHeight div 2 + 1;
            Caption := dm.tTutorArrange.FieldByName('TchrCode').AsString;  // AAA
            Transparent := true;
            Hint       := IntToStr(j);
            if f then Font.Color := clNavy
                 else Font.Color := clAqua;
            Font.Size  := 12;
            Font.Name  := 'sө';
            Layout     := tlCenter;
            Autosize   := false;
            Height     := defHeight div 2 - 1;
            Parent     := ClassAccessPanel;
            Tag          := 114499;
            if f then begin
              OnMouseEnter := ClassAccessMouseEnter;
              OnClick      := ClassAccessDefine;
            end;
            OnMouseLeave := ClassAccessMouseLeave;
          end;
          AccessRoomLabel[j] := TLabel.Create(Self);
          with AccessRoomLabel[j] do begin
            if j > 6 then Left := defWidth*3 + 40
                     else Left := 40;
            if j > 6 then Top  := (j-7)*defHeight div 2 + 1
                     else Top  := (j-1)*defHeight div 2 + 1;
            Caption    := dm.tTutorArrange.FieldByName('RoomID').AsString;
            if f then Font.Color := clNavy
                 else Font.Color := clAqua;
            Hint       := IntToStr(j);
            Transparent := true;
            Font.Size  := 6;
            Font.Name  := 'Times New Roman';
            Layout     := tlBottom;
            Autosize   := false;
            Height     := defHeight div 2 - 1;
            Tag          := 114499;
            Transparent  := true;
            Parent     := ClassAccessPanel;
            if f then begin
              OnMouseEnter := ClassAccessMouseEnter;
              OnClick      := ClassAccessDefine;
            end;
            OnMouseLeave := ClassAccessMouseLeave;
          end;
        dm.tTutorArrange.next;
        inc(j);
      end;
end;

procedure TSetDetail.DrawTeacherAccessDetail;
var j,n, u:integer;
    f:boolean;
begin
  TeacherAccessPanel.Caption := cTeacher;
  if dm.tTeacher.Locate('Code', cTeacher, []) then begin
    dm.tTutorArrange.Filter := 'TchrID = '''+dm.tTeacher.FieldByName('Name').AsString+'''';
    dm.tTutorArrange.first;
    j := 1;
    while not dm.tTutorArrange.Eof do begin
      n := pos(dm.tTutorArrange.FieldByName('TchrCode').AsString, UsedTeacher); // BBB
      if dm.tTutorArrange.FieldByName('RoomID').AsString = ''
      then u := 0
      else if UsedRoom = '' then u := 0
      else u:= pos(dm.tTutorArrange.FieldByName('RoomID').AsString+' ', UsedRoom);
      f := (n = 0) and (u = 0);
            TAccessClassLabel[j] := TLabel.Create(Self);
            with TAccessClassLabel[j] do begin
              if j > 9 then Left := defWidth*3 + 1
                       else Left := 1;
              if j > 9 then Top  := (j-10)*defHeight div 3
                       else Top  := (j-1)*defHeight div 3 ;
              Caption := dm.tTutorArrange.FieldByName('ClassID').AsString;
              Transparent := true;
              Hint       := IntToStr(j);
              if f then Font.Color := clNavy
                   else Font.Color := clAqua;
              Font.Size  := 8;
              Font.Name  := 'Arial';
              Layout     := tlCenter;
              Autosize   := false;
              Height     := defHeight div 3 - 1;
              Parent     := TeacherAccessPanel;
              Tag          := 114499;
              Transparent  := true;
              OnMouseEnter := txtMouseEnter;
              OnMouseLeave := txtMouseLeave;
              OnClick      := PreClassClick2;
            end;
          TAccessSubjectLabel[j] := TLabel.Create(Self);
          with TAccessSubjectLabel[j] do begin
            if j > 9 then Left := defWidth*3 + 18
                       else Left    := 18;
              if j > 9 then Top  := (j-10)*defHeight div 3 + 1
                       else Top  := (j-1)*defHeight div 3 + 1;
              Caption := dm.tTutorArrange.FieldByName('Subj').AsString;
              if f then Font.Color := clNavy
                   else Font.Color := clAqua;
              Font.Size  := 12;
              Font.Name  := 'sө';
              Layout     := tlCenter;
              Transparent := true;
              Autosize   := false;
              Hint       := IntToStr(j);
              Height     := defHeight div 3 - 1;
              Parent     := TeacherAccessPanel;
              Tag          := 114499;
            end;
            TAccessRoomLabel[j] := TLabel.Create(Self);
            with TAccessRoomLabel[j] do begin
              if j > 9 then Left := defWidth*3 + 40
                       else Left := 40;
              if j > 9 then Top  := (j-10)*defHeight div 3 + 1
                       else Top  := (j-1)*defHeight div 3 + 1;
              Caption    := dm.tTutorArrange.FieldByName('RoomID').AsString;
              if f then Font.Color := clNavy
                   else Font.Color := clAqua;
              Hint       := IntToStr(j);
              Transparent := true;
              Font.Size  := 6;
              Font.Name  := 'Times New Roman';
              Layout     := tlBottom;
              Transparent  := true;
              Autosize   := false;
              Height     := defHeight div 3 - 1;
              Tag          := 114499;
              Parent     := TeacherAccessPanel;
            end;
          dm.tTutorArrange.next;
          inc(j);
        end;
  end; { end of locate }
  dm.tTutorArrange.Filter := 'ClassID = '''+cClass+'''';
end;

procedure TSetDetail.DrawTeacherPanel;
var i,j:integer;
begin
  dm.tClass.First;
//  for i := 1 to mClass do begin
  for i := 1 to 1 do begin
    TeacherPanel := TPanel.Create(Self);
    { draw panel ==============================================================}
    with TeacherPanel do begin
      Autosize     := false;
      Left         := ClassAccessPanel.Left+ ClassAccessPanel.Width + 13;
      Top          := ClassPanel.Top;
//      Top          := ClassAccessPanel.Top + ClassAccessPanel.Height + 2;
      Width        := defWidth * (maxDay+1) + 1;
      Height       := defHeight * maxRow + defClassHeight + 1;
      Alignment    := taCenter;
      Font.Name    := 'з';
      Font.Size    := 72;
      Font.Color   := $00E1C4FF;
      Color        := $00CEFFFF;
      BevelOuter   := bvNone;
      BevelInner   := bvNone;
      Caption      := dm.tClass.FieldByName('ID').AsString;
      dm.tClass.next;
      Tag          := i;
      Parent       := Self;
      for j := 0 to maxDay+1 do begin
        { draw vertical lines -------------------------------------------------}
        if not (j in [maxDay+2, maxDay+3]) then
        with TShape.Create(Self) do begin
          if j = 0 then Left := 0
                   else Left := defWidth * j;
          Top         := 0;
          Width       := 1;
          Height      := ClassPanel.Height;
          Pen.Color   := clAqua;
          Brush.Style := bsClear;
          ShowHint    := true;
          Hint        := 'Left = '+IntToStr(Left);
          Parent      := TeacherPanel;
        end;
        { draw week day number @ to  ---------------------------------------}
        if j in [1..5] then
        with TLabel.Create(Self) do begin
          Top          := 1;
          Left         := defWidth * (j);
          Autosize     := false;
          Alignment    := taCenter;
          Layout       := tlCenter;
          Height       := defClassHeight - 1;
          Width        := defWidth - 1;
          Font.Color   := clNavy;
          Font.Name    := 'Arial';
          Font.Size    := 12;
          Transparent  := true;
          Tag          := j;
          Parent       := TeacherPanel;
          OnMouseEnter := txtMouseEnter;
          OnMouseLeave := txtMouseLeave;
          Caption      := Copy(Days[j],5,2);
          OnClick      := PreDayClick;
        end;
      end;
      for j := 0 to maxRow+1 do begin
        { draw horizontal lines -----------------------------------------------}
        with TShape.Create(Self) do begin
          case j of
            0 : Top := 0;
            1 : Top := defClassHeight;
            else Top := defHeight * (j-1) + defClassHeight;
          end;
          Left         := 0;
          Height       := 1;
          if j in [0, maxRow+1] then Width := ClassPanel.Width
                                else Width := defWidth * 6;
          Pen.Color   := clAqua;
          ShowHint    := true;
          Hint        := 'Top = '+IntToStr(Top);
          Brush.Style := bsClear;
          Parent      := TeacherPanel;
        end;
        { draw lesson number 1 to 9 -------------------------------------------}
        if j in [1..maxRow] then begin
          CNbrLabel[j] := TLabel.Create(Self);
          with CNbrLabel[j] do begin
            case j of
              1 : Top := defClassHeight+1;
              else Top := defHeight * (j-1) + defClassHeight + 1;
            end;
            Left         := 0;
            Autosize     := false;
            Alignment    := taCenter;
            Layout       := tlCenter;
            Height       := defHeight - 1;
            Width        := defWidth - 1;
            Font.Color   := clNavy;
            Font.Name    := 'Arial';
            Font.Size    := 12;
            Transparent  := true;
            Parent       := TeacherPanel;
            Tag          := j;
            OnMouseEnter := txtMouseEnter;
            OnMouseLeave := txtMouseLeave;
            Caption      := IntToStr(j);
            OnClick      := DNbrClick;
          end;
        end;
      end;
    end;
  end;
end;

procedure TSetDetail.ReadDetail;
var i,j:integer;
begin
  if not dm.tDetail.Active then dm.tDetail.Open;
  dm.tDetail.first;
  i := 1;
  while not dm.tDetail.eof do begin
    Details[i].RecID       := dm.tDetail.FieldByName('ID').AsInteger;
    Details[i].DayCode     := dm.tDetail.FieldByName('DayCode').AsInteger;
    Details[i].LessonCode  := dm.tDetail.FieldByName('LessonCode').AsInteger;
    Details[i].ClassCode   := dm.tDetail.FieldByName('ClassCode').AsString;
    for j := 1 to mClass
      do if ClassLabel[j].Caption = Details[i].ClassCode then Details[i].ClassID := j;
    Details[i].SubjectID   := dm.tDetail.FieldByName('SubjectID').AsInteger;

    Details[i].SubjectCode := dm.tDetail.FieldByName('SubjectCode').AsString;

    Details[i].TeacherID   := dm.tDetail.FieldByName('TeacherID').AsInteger;
{    if Details[i].TeacherID = 18 then begin
      ShowMessage('It changed 3');
    end;}
    Details[i].TeacherCode := dm.tDetail.FieldByName('TeacherCode').AsString;
    Details[i].RoomCode    := dm.tDetail.FieldByName('RoomCode').AsString;
    if (dm.tDetail.FieldByName('TeacherCode').AsString[1] <> '') and (pos(dm.tDetail.FieldByName('TeacherCode').AsString[1], TeacherList) = 0) then begin
      TeacherList := TeacherList + dm.tDetail.FieldByName('TeacherCode').AsString[1];
    end;
    dm.tDetail.next;
    inc(i);
  end;
  dm.qTeacherList.ParamByName('LastYear').AsInteger := vSchYear;
  dm.qTeacherList.Open;
  dm.qTeacherList.First;
  TeacherList := '';
  while not dm.qTeacherList.eof do begin
    TeacherList := TeacherList + dm.qTeacherList.FieldByName('TeacherCode').AsString;
    dm.qTeacherList.Next;
  end;
  mDetail  := dm.tDetail.RecordCount;
  mTeacher := Length(TeacherList);
end;

procedure TSetDetail.WriteDetail;
var i:integer;
begin
  if not dm.tDetail.Active then dm.tDetail.Open;
  for i := 1 to mDetail do begin
    if dm.tDetail.Locate('ID', Details[i].RecID, []) then begin
      dm.tDetail.edit;
      dm.tDetail.FieldByName('DayCode').AsInteger := Details[i].DayCode;
      dm.tDetail.FieldByName('LessonCode').AsInteger := Details[i].LessonCode;
      dm.tDetail.FieldByName('ClassCode').AsString := Details[i].ClassCode;

      dm.tDetail.FieldByName('SubjectCode').AsString := Details[i].SubjectCode;
      dm.tDetail.FieldByName('SubjectID').AsInteger := Details[i].SubjectID;
      dm.tDetail.FieldByName('TeacherID').AsInteger := Details[i].TeacherID;
      dm.tDetail.FieldByName('TeacherCode').AsString := Details[i].TeacherCode;
      dm.tDetail.FieldByName('RoomCode').AsString := Details[i].RoomCode;
      dm.tDetail.post;
    end
    else begin
      ShowMessage('Error : write details');
    end;
  end;
end;

procedure TSetDetail.DrawDetail;
var i,j,k,z:integer;
begin
  for j := 1 to maxDay do for k := 1 to maxRow do ClassFill[j,k] := false;
  for i := 1 to maxSubject do SubjectReduction[i] := 0;
  for i := ComponentCount-1 downto 0 do begin
    if Components[i].Tag = 114499 then Components[i].free; //Tag := 114500;
  end;
  z := 0;
  for i := 1 to mDetail do begin
    if (Details[i].DayCode = cDay)
    and (Details[i].LessonCode > 0)
    and (Details[i].ClassID > 0) then begin
      inc(z);
      ClassDisplay[z]   := TLabel.Create(Self);
      SubjectDisplay[z] := TLabel.Create(Self);
      TeacherDisplay[z] := TLabel.Create(Self);
      RoomDisplay[z]    := TLabel.Create(Self);
      LessonDisplay[z]  := Details[i].LessonCode;
      DayDisplay[z]     := Details[i].DayCode;
      with ClassDisplay[z] do begin
        Autosize := false;
        Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 1;
        Left     := (Details[i].ClassID) * defWidth + 1;
        Width    := defWidth - 1;
//        Color    := clCream;
        Caption     := Details[i].ClassCode;
        Transparent := true;
        Alignment   := taLeftJustify;
        Font.Size   := 8;
        Font.Name   := 'Times New Roman';
        Font.Color  := clBlue;
        Tag         := 114499;
        Parent      := DayPanel;
        Hint        := IntToStr(i);
        OnClick     := PreClassClickZ;
        OnDblClick  := DeleteInfo;
      end;
      with SubjectDisplay[z] do begin
        Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 14;
        Left     := (Details[i].ClassID) * defWidth + 1;
//        Color    := clCream;
        Caption  := Details[i].SubjectCode;
        Transparent := true;
        Font.Size := 12;
        Font.Name := 'sө';
        Font.Color := clBlue;
        Alignment := taCenter;
        Autosize := false;
        Width    := defWidth - 1;
        Tag        := 114499;
        Parent   := DayPanel;
        Hint       := IntToStr(i);
        OnClick    := PreClassClickZ;
        OnDblClick := DeleteInfo;
      end;
      with TeacherDisplay[z] do begin
        Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 31;
        Left     := (Details[i].ClassID) * defWidth + 1;
//        Color    := clYellow;
        Caption  := Details[i].TeacherCode;
        Transparent := true;
        Font.Size := 12;
        Font.Name := 'sө';
        Font.Color := clBlue;
        Alignment := taCenter;
        Autosize := false;
        Width    := defWidth - 1;
        Tag        := 114499;
        Parent   := DayPanel;
        Hint       := IntToStr(i);
        OnClick    := PreClassClickZ;
        OnDblClick := DeleteInfo;
      end;
      with RoomDisplay[z] do begin
        Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 48;
        Left     := (Details[i].ClassID) * defWidth + 1;
//        Color    := clYellow;
        Caption  := Details[i].RoomCode;
        Font.Size := 7;
        Font.Name := 'Times New Roman';
        Transparent := true;
        Font.Color := clBlue;
        Alignment := taRightJustify;
        Autosize := false;
        Width    := defWidth - 1;
        Tag        := 114499;
        Parent   := DayPanel;
        Hint       := IntToStr(i);
        OnClick    := PreClassClickZ;
        OnDblClick := DeleteInfo;
      end;
    end;


    if (Details[i].ClassCode = cClass) then begin
      ClassPanel.Caption := cClass;
      if (Details[i].DayCode > 0)
      and (Details[i].LessonCode > 0) then begin
        ClassFill[Details[i].DayCode, Details[i].LessonCode] := true;
        with TLabel.Create(Self) do begin
          Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 1;
          Left     := (Details[i].DayCode) * defWidth + 1;
//          Color    := clYellow;
          Caption  := Details[i].ClassCode;
          Font.Size := 7;
          Font.Name := 'Times New Roman';
          Font.Color := clBlue;
          Alignment := taLeftJustify;
          Autosize := false;
          Width    := defWidth - 1;
          Tag        := 114499;
          Transparent := true;
          Parent   := ClassPanel;
        end;
        with TLabel.Create(Self) do begin
          Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 14;
          Left     := (Details[i].DayCode) * defWidth + 1;
//          Color    := clYellow;
          Caption  := Details[i].SubjectCode;
          inc(SubjectReduction[Details[i].SubjectID]);
//          ShowMessage(Details[i].ClassCode+Details[i].SubjectCode+Details[i].TeacherCode+IntToStr(Details[i].SubjectID));
          Font.Size := 12;
          Font.Name := 'sө';
          Font.Color := clBlue;
          Alignment := taCenter;
          Autosize := false;
          Width    := defWidth - 1;
          Tag        := 114499;
          Transparent := true;
          Parent   := ClassPanel;
        end;
        with TLabel.Create(Self) do begin
          Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 31;
          Left     := (Details[i].DayCode) * defWidth + 1;
//          Color    := clYellow;
          Caption  := Details[i].TeacherCode;
          Font.Size := 12;
          Font.Name := 'sө';
          Font.Color := clBlue;
          Alignment := taCenter;
          Autosize := false;
          Width    := defWidth - 1;
          Tag        := 114499;
          Transparent := true;
          Parent   := ClassPanel;
          OnClick  := PreTeacherClick;
          Hint     := IntToStr(i);
        end;
        with TLabel.Create(Self) do begin
          Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 48;
          Left     := (Details[i].DayCode) * defWidth + 1;
//          Color    := clYellow;
          Caption  := Details[i].RoomCode;
          Font.Size := 7;
          Font.Name := 'Times New Roman';
          Font.Color := clBlue;
          Alignment := taRightJustify;
          Autosize := false;
          Width    := defWidth - 1;
          Tag        := 114499;
          Transparent := true;
          Parent   := ClassPanel;
        end;
      end; { end if }
    end;

    if (Details[i].TeacherCode = cTeacher) then begin
      TeacherPanel.Caption := cTeacher;
      if (Details[i].DayCode > 0)
      and (Details[i].LessonCode > 0) then begin
        with TLabel.Create(Self) do begin
          Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 1;
          Left     := (Details[i].DayCode) * defWidth + 1;
//          Color    := clYellow;
          Caption  := Details[i].ClassCode;
          Font.Size := 7;
          Font.Name := 'Times New Roman';
          Font.Color := clBlue;
          Alignment := taLeftJustify;
          Autosize := false;
          Width    := defWidth - 1;
          Tag        := 114499;
          Transparent := true;
          Parent   := TeacherPanel;
          OnClick  := PreClassClick;
          Hint     := IntToStr(i);
        end;
        with TLabel.Create(Self) do begin
          Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 14;
          Left     := (Details[i].DayCode) * defWidth + 1;
//          Color    := clYellow;
          Caption  := Details[i].SubjectCode;
          Font.Size := 12;
          Font.Name := 'sө';
          Font.Color := clBlue;
          Alignment := taCenter;
          Autosize := false;
          Width    := defWidth - 1;
          Tag        := 114499;
          Transparent := true;
          Parent   := TeacherPanel;
        end;
        with TLabel.Create(Self) do begin
          Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 31;
          Left     := (Details[i].DayCode) * defWidth + 1;
//          Color    := clYellow;
          Caption  := Details[i].TeacherCode;
          Font.Size := 12;
          Font.Name := 'sө';
          Font.Color := clBlue;
          Alignment := taCenter;
          Autosize := false;
          Width    := defWidth - 1;
          Tag        := 114499;
          Transparent := true;
          Parent   := TeacherPanel;
          OnClick  := PreTeacherClick;
          Hint     := IntToStr(i);
        end;
        with TLabel.Create(Self) do begin
          Top      := (Details[i].LessonCode-1) * defHeight + defClassHeight + 48;
          Left     := (Details[i].DayCode) * defWidth + 1;
//          Color    := clYellow;
          Caption  := Details[i].RoomCode;
          Font.Size := 7;
          Font.Name := 'Times New Roman';
          Font.Color := clBlue;
          Alignment := taRightJustify;
          Autosize := false;
          Width    := defWidth - 1;
          Tag        := 114499;
          Transparent := true;
          Parent   := TeacherPanel;
        end;
      end; { end if }
    end;
  end;

  for j := 1 to maxDay do for k := 1 to maxRow do begin
//    if Assigned(ClassItem[j,k]) then ClassItem[j,k].free;
    if ClassFill[j,k] = false then begin
      ClassItem[j,k] := TSelectLabel.Create(Self);
      with TSelectLabel(ClassItem[j,k]) do begin
        Autosize := false;
        Color    := $00A2FFFF;
        Top      := (k-1) * defHeight + defClassHeight + 1;
        Left     := (j) * defWidth + 1;
        Height   := defHeight - 1 ;
        Width    := defWidth - 1;
        Caption     := '';
        Transparent := true;
        OnMouseEnter := optMouseEnter;
        OnMouseLeave := optMouseLeave;
        Parent       := ClassPanel;
        vDay         := j;
        vLesson      := k;
        Tag          := 114499;
        OnClick      := ClassAccessClick;
      end;
    end;
    end;
  DrawClassAccessDetail;
  DrawTeacherAccessDetail;
//  ClassPanel.Caption := cClass;
end;

procedure TSetDetail.ClassAccessMouseEnter(Sender: TObject);
var j:integer;
begin
  j := StrToInt(TLabel(Sender).Hint);
  ClassAccessSelect.Parent := ClassAccessPanel;
  with ClassAccessSelect do begin
   if j > 6 then Left := defWidth*3 + 1
            else Left    := 1;
   if j > 6 then Top  := (j-7)*defHeight div 2 + 1
            else Top  := (j-1)*defHeight div 2 + 1;
   Height := defHeight div 2 - 1;
   Width  := defWidth * 3;
   Visible := true;
   Parent  := ClassAccessPanel;
   SendToBack;
  end;
end;

procedure TSetDetail.ClassAccessMouseLeave(Sender: TObject);
begin
  ClassAccessSelect.Visible := false;
end;

procedure TSetDetail.ClassAccessClick(Sender: TObject);
begin
  GetUsedTeacher(TSelectLabel(Sender).vDay, TSelectLabel(Sender).vLesson);
  GetUsedRoom(TSelectLabel(Sender).vDay, TSelectLabel(Sender).vLesson);
  if DrawTimer.Enabled = false then DrawTimer.Enabled := true;
  ClassAccessBox.Left    := TLabel(Sender).Left;
  ClassAccessBox.Top     := TLabel(Sender).Top;
  ClassAccessBox.Height  := TLabel(Sender).Height;
  ClassAccessBox.Width   := TLabel(Sender).Width;
  ClassAccessBox.Visible := true;
  ClassAccessBox.Parent  := ClassPanel;
  thisDay                := TSelectLabel(Sender).vDay;
  thisLesson             := TSelectLabel(Sender).vLesson;
  thisClass              := cClass;
  ClassAccessBox.SendToBack;
  if thisDay <> cDay then
  DayLabel[thisDay].OnClick(DayLabel[thisDay]);
  DNbrLabel[thisLesson].OnClick(DNbrLabel[thisLesson]);
end;

procedure TSetDetail.GetUsedTeacher(DayNbr, LessonNbr:integer);
var i:integer;
begin
  UsedTeacher := '';
  for i := 1 to mDetail do begin
    if (Details[i].DayCode = DayNbr) and (Details[i].LessonCode = LessonNbr) then begin
      if pos(Details[i].TeacherCode, UsedTeacher) = 0 then begin
        UsedTeacher := UsedTeacher + Details[i].TeacherCode;
      end;
    end;
  end;
end;

procedure TSetDetail.GetUsedRoom(DayNbr, LessonNbr:integer);
var i:integer;
begin
  UsedRoom := '';
  for i := 1 to mDetail do begin
    if (Details[i].DayCode = DayNbr) and (Details[i].LessonCode = LessonNbr) then begin
      if (Details[i].RoomCode <> '') and (pos(Details[i].RoomCode, UsedRoom) = 0) then begin
        UsedRoom := UsedRoom + '*'+Details[i].RoomCode+' ';
      end;
    end;
  end;
end;

procedure TSetDetail.ClassAccessDefine(Sender: TObject);
var i,k, n:integer;
begin
  k := 0;
  n := StrToInt(TLabel(Sender).Hint);
  thisSubject := AccessSubjectLabel[n].Caption;
  thisTeacher := AccessTeacherLabel[n].Caption;
  thisRoom    := AccessRoomLabel[n].Caption;
  for i := 1 to mDetail do begin
    if  (Details[i].ClassCode = thisClass)
    and (Details[i].SubjectCode = thisSubject)
    and (Details[i].TeacherCode = thisTeacher)
    and (Details[i].DayCode = 0)
    and (Details[i].LessonCode = 0) then begin
      k := i;
    end;
  end;
  if k > 0 then begin
    Details[k].DayCode    := thisDay;
    Details[k].LessonCode := thisLesson;
    if dm.qSubject.Locate('Code', thisSubject, []) then Details[k].SubjectID := dm.qSubject.FieldByName('ID').AsInteger;
    if thisDay <> 0 then cDay       := thisDay;
  end;
  thisday    := 0;
  thislesson := 0;
  if DrawTimer.Enabled = false then begin
    DayLabel[cDay].OnClick(DayLabel[cDay]);
  end;
//  DrawDetail;
end;

procedure TSetDetail.DrawTimerTimer(Sender: TObject);
begin
  DrawTimer.Enabled := false;
  DrawDetail;
//  UsedTeacher := '';
end;

procedure TSetDetail.DeleteInfo(Sender: TObject);
var i,z:integer;
    thatClass, thatTeacher, thatSubject, thatRoom:string[4];
    thatLesson, thatDay : integer;
begin
  z := StrToInt(TLabel(Sender).Hint);
  thatClass   := Details[z].ClassCode;
  thatSubject := Details[z].SubjectCode;
  thatTeacher := Details[z].TeacherCode;
  thatRoom    := Details[z].RoomCode;
  thatLesson  := Details[z].LessonCode;
  thatDay     := Details[z].DayCode;
  for i := 1 to mDetail do begin
    if  (Details[i].ClassCode   = thatClass)
    and (Details[i].SubjectCode = thatSubject)
    and (Details[i].TeacherCode = thatTeacher)
    and (Details[i].DayCode     = thatDay)
    and (Details[i].LessonCode  = thatLesson) then begin
      Details[i].DayCode    := 0;
      Details[i].LessonCode := 0;
    end;
  end;
  if DrawTimer.Enabled = false then begin
    DayLabel[cDay].OnClick(DayLabel[cDay]);
  end;
//  DrawDetail;
end;

procedure TSetDetail.btnExcelClick(Sender: TObject);
var MyExcel: Variant;
    i,j,k:integer;
    ii:integer;
    Scap :string;
    s:string;
    TempStr:string;
    t:array [1..9] of string;
begin
  GetDir(0,s);
  MyExcel := CreateOleOBject('Excel.Application');
  for ii := 1 to mClass do begin
    CopyFile(PChar(s+'\TimeTable.xls'), PChar(s+'\Yr2015TimeTable'+ClassLabel[ii].Caption+'.xls'), False);
    MyExcel.WorkBooks.open(s+'\Yr2015TimeTable'+ClassLabel[ii].Caption+'.xls');
    MyExcel.Visible := true;
    MyExcel.WorkBooks[1].WorkSheets[1].Cells[11,1] := 'ZOG '+ClassLabel[ii].Caption;
    for i := 1 to mDetail do
    if (Details[i].ClassCode = ClassLabel[ii].Caption)
    and (Details[i].DayCode <> 0) then begin
      j    := Details[i].DayCode;
      k    := Details[i].LessonCode;
      Scap := Details[i].SubjectCode;
      case k of
        1..9:MyExcel.WorkBooks[1].WorkSheets[1].Cells[k,j]  := Scap;
      end;
    end;
    MyExcel.WorkBooks[1].Save;
    MyExcel.WorkBooks.Close;
  end;
  for ii := 1 to mTeacher do begin
    CopyFile(PChar(s+'\TimeTable.xls'), PChar(s+'\Yr2015TimeTable('+TeacherLabel[ii].Caption+').xls'), False);
    MyExcel.WorkBooks.open(s+'\Yr2015TimeTable('+TeacherLabel[ii].Caption+').xls');
    MyExcel.Visible := true;
    for i := 1 to mDetail do
    if (Details[i].TeacherCode = TeacherLabel[ii].Caption)
    and (Details[i].DayCode <> 0) then begin
      j    := Details[i].DayCode;
      k    := Details[i].LessonCode;
      Scap := Details[i].ClassCode+' '+Details[i].SubjectCode;
      case k of
        1..9:MyExcel.WorkBooks[1].WorkSheets[1].Cells[k,j]  := Scap;
      end;
    end;
    MyExcel.WorkBooks[1].WorkSheets[1].Cells[3,1].Font.Name := 'з';
    if dm.tTeacher.Locate('Code', TeacherLabel[ii].Caption, [])
    then TempStr := dm.tTeacher.FieldByName('Name').AsString
    else Tempstr := '';
    MyExcel.WorkBooks[1].WorkSheets[1].Cells[11,1] := '('+TeacherLabel[ii].Caption+') '+Tempstr + ' Ѯv';
    MyExcel.WorkBooks[1].Save;
    MyExcel.WorkBooks.Close;
  end;
  for ii := 1 to maxDay do begin
    CopyFile(PChar(s+'\TimeTableDays.xls'), PChar(s+'\Yr2015TimeTable('+EDays[ii]+').xls'), False);
    MyExcel.WorkBooks.open(s+'\Yr2015TimeTable('+EDays[ii]+').xls');
    MyExcel.Visible := true;
    MyExcel.WorkBooks[1].WorkSheets[1].Cells[1,26+15]  := '('+Days[ii]+')';
    for i := 1 to maxRow do t[i] := TeacherList;
    for i := 1 to mClass do begin
      MyExcel.WorkBooks[1].WorkSheets[1].Cells[2+3,i+2]  := ClassLabel[i].Caption;
    end;
    for i := 1 to mDetail do
    if (Details[i].DayCode = ii) then begin
      j    := Details[i].ClassID;
      k    := Details[i].LessonCode;
      case k of
        1..9:begin
               MyExcel.WorkBooks[1].WorkSheets[1].Cells[k*2+6,j+2]  := Details[i].SubjectCode;
               MyExcel.WorkBooks[1].WorkSheets[1].Cells[k*2+7,j+2]  := Details[i].TeacherCode;
               if pos(Details[i].TeacherCode, t[Details[i].LessonCode]) > 0 then begin
                 delete(t[Details[i].LessonCode], pos(Details[i].TeacherCode, t[Details[i].LessonCode]),1);
               end;
             end;
      end;
    end;
    for i := 1 to maxRow do begin
      j := 0;
      while length(t[i]) > 0 do begin
        inc(j);
        MyExcel.WorkBooks[1].WorkSheets[1].Cells[i*2+6, 26+j] := Copy(t[i],1,1);
        delete(t[i],1,1);
      end;
    end;
    MyExcel.WorkBooks[1].Save;
    MyExcel.WorkBooks.Close;
  end;

  MyExcel.Quit;
end;

procedure TSetDetail.btnSubjectClick(Sender: TObject);
var MyExcel: Variant;
    i,j,k:integer;
    ii:integer;
    Scap :string;
    s:string;
    TempStr:string;
    t:array [1..9] of string;
    SubjArr1:string;
    SubjArr2:string;
    SubjArr3:string;
    SubjShort:string;
begin
  SubjArr1 := '^Ʊ`qϴ';
  SubjArr2 := '֨|ѳq';
  SubjArr3 := '@@@@@@@@@';
  GetDir(0,s);
  MyExcel := CreateOleOBject('Excel.Application');
  for ii := 1 to length(SubjArr1) do begin
    if SubjArr3[ii] = '@'
    then SubjShort := SubjArr1[ii]+SubjArr2[ii]
    else SubjShort := SubjArr1[ii]+SubjArr2[ii]+SubjArr3[ii];
    CopyFile(PChar(s+'\TimeTableSubject.xls'), PChar(s+'\Yr2015TimeTableSubject('+SubjShort+').xls'), False);
    MyExcel.WorkBooks.open(s+'\Yr2015TimeTableSubject('+SubjShort+').xls');
    MyExcel.Visible := true;
    MyExcel.WorkBooks[1].WorkSheets[1].Cells[11,1] := ''+SubjShort+''+'';
    for i := 1 to mDetail do
    if (Details[i].SubjectCode = SubjArr1[ii])
    and (Details[i].DayCode <> 0) then begin
      j    := Details[i].DayCode;
      k    := Details[i].LessonCode;
      TempStr := MyExcel.WorkBooks[1].WorkSheets[1].Cells[k,j];
      if TempStr = ''
      then Scap := Details[i].ClassCode
      else Scap := TempStr+' '+Details[i].ClassCode;
      case k of
        1..9:MyExcel.WorkBooks[1].WorkSheets[1].Cells[k,j]  := Scap;
      end;
    end;
    MyExcel.WorkBooks[1].Save;
    MyExcel.WorkBooks.Close;
  end;
  MyExcel.Quit;
end;

procedure TSetDetail.btnCloseClick(Sender: TObject);
begin
  close;
end;

procedure TSetDetail.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  WriteDetail;
end;

end.


